;; ##################################################################################
;; # ============================================================================== #
;; # ABC - gui.ss                                                                   #
;; # http://abc.lozi.org                                                            #
;; # Copyright (C) Lozi Jean-Pierre, 2004 - mailto:jean-pierre@lozi.org             #
;; # ============================================================================== #
;; #                                                                                #
;; # This program is free software; you can redistribute it and/or                  #
;; # modify it under the terms of the GNU General Public License                    #
;; # as published by the Free Software Foundation; either version 2                 #
;; # of the License, or (at your option) any later version.                         #
;; #                                                                                #
;; # This program is distributed in the hope that it will be useful,                #
;; # but WITHOUT ANY WARRANTY; without even the implied warranty of                 #
;; # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                  #
;; # GNU General Public License for more details.                                   #
;; #                                                                                #
;; # You should have received a copy of the GNU General Public License              #
;; # along with this program; if not, write to the Free Software                    #
;; # Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.    #
;; #                                                                                #
;; ##################################################################################

;; The about dialog module.
(module about-dialog mzscheme
  
  ;; Requirements
  (require (lib "mred.ss" "mred")
           (lib "sendurl.ss" "net")
           (lib "string.ss" "srfi" "13")
           (lib "class.ss"))
  
  (provide about)
  
  (define about-canvas%
    ;; This class is inherited from a canvas.
    (class canvas%
      ;; Here are some drawing constants...
      (define k-black (make-object color% 0 0 0))
      (define k-underline-brush (make-object brush% (make-object color% 118 118 118) 'solid))
      (define k-invisible-pen (make-object pen%  k-black 0 'transparent))
      (define k-arrow-cursor (make-object cursor% 'arrow))
      ;; We cannot use the default hand cursor because under MacOS X, for example, it is an open hand...
      ;; Here is something really strange I found out : under MacOS X the image and mask have to be swapped,
      ;; I reckon this is a MrEd Bug.
      (define k-hand-cursor (if (eq? (system-type) 'macosx)
                                (make-object cursor% 
                                  (make-object bitmap% (build-path "images" "hand-cursor-mask.xbm") 'xbm (make-object color% 255 255 255))
                                  (make-object bitmap% (build-path "images" "hand-cursor.xbm") 'xbm (make-object color% 255 255 255))
                                  6 2)
                                (make-object cursor% 
                                  (make-object bitmap% (build-path "images" "hand-cursor.xbm") 'xbm (make-object color% 255 255 255))
                                  (make-object bitmap% (build-path "images" "hand-cursor-mask.xbm") 'xbm (make-object color% 255 255 255))
                                  6 2)))
      ;; Here is the bitmap and the associated dc used in the on-paint method.
      (define bitmap (make-object bitmap% 331 212 #f))
      (define dc (make-object bitmap-dc% bitmap))
      
      ;; These variable save the status of the website link...
      (define website-address-focused #f)
      
      ;; We define the main picture...
      (define k-logo (make-object bitmap% (build-path "images" "logo.png") 'png #f))
      
      ;; The overriden methods list...
      (override on-event on-paint)
      
      ;; The on-event method...
      (define on-event (lambda (event) 
                         ;; We assign the coordinates to x and y.
                         (let ((x    (send event get-x))
                               (y    (send event get-y)))
                           ;; What is the event type?
                           (case (send event get-event-type)
                             ;; Is it a motion event?
                             ((motion)
                              ;; Therefore, update the status of the links...
                              (cond ((and (not (and (<= 218 x 318) (<= 188 y 200))) website-address-focused)
                                     (set! website-address-focused #f))
                                    ((and (and (<= 218 x 318) (<= 188 y 200)) (not website-address-focused))
                                     (set! website-address-focused #t)))
                              ;; ...update the cursor...
                              (if (or (and (<= 218 x 318) (<= 188 y 200)))
                                  (send this set-cursor k-hand-cursor)
                                  (send this set-cursor k-arrow-cursor))
                              ;; ...and call on-paint.
                              (send this on-paint))
                             
                             ;; Is it a left-down event?
                             ((left-down)
                              ;; Then locate it and call the appropriate URL...
                              (if (and (<= 218 x 318) (<= 188 y 200))
                                  (send-url "http://www.lozi.org/abc/support.php")))))))
      
      ;; The on-paint method...
      (define on-paint (lambda ()
                         ;; We draw the logo...
                         (send dc draw-bitmap k-logo 0 0 'solid (make-object color% 0 0 0) #f)
                         ;; ...update the brush/pen...
                         (send dc set-pen k-invisible-pen)
                         (send dc set-brush k-underline-brush)
                         ;; ...underline the focused link (if any)...
                         (if website-address-focused
                             (send dc draw-rectangle 220 200 96 1))
                         ;; ...and then draw the updated bitmap in the real dc.
                         (send (send this get-dc) draw-bitmap bitmap 0 0 'solid k-black #f)))
      
      ;; And then we call the default canvas initialization method.
      (super-instantiate ())))
  
;; This function is called when the user chooses "About ABC..." in the help menu
(define (about)  
  ;; Let's build the whole dialog using a let*
  (let*  ((dialog (new dialog% (label "About ABC...") (parent #f) (width 331) (height 212)))
          ;; The main vertical pane...
          (vertical-pane (new vertical-pane% (parent dialog) (border 5)))
          ;; We call the derived canvas class...
          (canvas (new about-canvas% (parent vertical-pane) (style '(border)) (min-width 331) (min-height 212)))
          ;; A very, very summed up information about the license...
          ;(message1 (new message% (label "This software is distributed under the terms of the General Public License (GPL),") (parent vertical-pane)))
          ;(message2 (new message% (label "either version 2 of the license, or (at your option) any later version.") (parent vertical-pane)))
          ;; The buttons' pane...
          (horizontal-pane (new horizontal-panel% (parent vertical-pane) (alignment '(center center))))
          ;; The 3 buttons...
          (button (new button% (label "Website...") (min-width 166)(parent horizontal-pane)
                       (callback (lambda (button control-event)
                                   (send-url "http://www.lozi.org/abc/reference.php")))))
          (button (new button% (label "Close") (min-width 166)(parent horizontal-pane)
                       (callback (lambda (button control-event)
                                   (send dialog show #f))))))
    ;; The main function body
    (send dialog center)
    (send dialog show #t))))