;; ##################################################################################
;; # ============================================================================== #
;; # ABC - line-numbers-widget                                                      #
;; # http://abc.lozi.org                                                            #
;; # Copyright (C) Lozi Jean-Pierre, 2004 - mailto:jean-pierre@lozi.org             #
;; # ============================================================================== #
;; #                                                                                #
;; # This program is free software; you can redistribute it and/or                  #
;; # modify it under the terms of the GNU General Public License                    #
;; # as published by the Free Software Foundation; either version 2                 #
;; # of the License, or (at your option) any later version.                         #
;; #                                                                                #
;; # This program is distributed in the hope that it will be useful,                #
;; # but WITHOUT ANY WARRANTY; without even the implied warranty of                 #
;; # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                  #
;; # GNU General Public License for more details.                                   #
;; #                                                                                #
;; # You should have received a copy of the GNU General Public License              #
;; # along with this program; if not, write to the Free Software                    #
;; # Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.    #
;; #                                                                                #
;; ##################################################################################

;; The line numbers widget module.
(module line-numbers-widget mzscheme
  
  ;; Requirements
  (require (lib "mred.ss" "mred")
           (lib "class.ss"))
  
  ;; We provide the line-numbers-widget% widget.
  (provide line-numbers-widget%)
  
  ;; To define our widget...
  (define line-numbers-widget%
    ;; ...we derive a canvas.
    (class canvas%
      ;; The on-paint method is overriden.
      (override on-paint)
      
      ;; Public functions
      (public get-line-numbers-list set-line-numbers-list set-line-spacing)
      
      ;; Global variables
      (define line-spacing 0)
      (define line-numbers-list '())
      (define font (make-object font% 12 'modern 'normal 'normal #f 'default #t)) 
      
      ;; Accessors
      (define (get-line-numbers-list) line-numbers-list)
      
      ;; Modifiers
      (define (set-line-numbers-list str) (set! line-numbers-list str))
      (define (set-line-spacing value) (set! line-spacing value))
      
      ;; The on-paint method.
      (define (on-paint)
        ;; We first get the dc...
        (let ((dc (send this get-dc)))
          ;; ...clear it...
          (send dc clear)
          ;; Then we declare the draw-list method, which draws the line-numbers list.
          (letrec ((draw-list (lambda (L x y)
                                ;; If the list is empty, we have nothing more to do.
                                (if (null? L) (void)
                                    ;; Otherwise, we get the current string's extent...
                                    (let-values (((width height descent space) (send dc get-text-extent (car L) font #f 0)))
                                      ;; ...draw the text...
                                      (send dc draw-text (car L) x y)
                                      ;; ...and then go on with the next line.
                                      (draw-list (cdr L) x (+ y height line-spacing)))))))
            ;; Then we call the draw-list function.
            (draw-list line-numbers-list 5 7))))
      
      ;; Parent-class initialization.
      (super-new)
      
      ;; Now that the object is created, we are able to set the panel background...
      (send (send this get-dc) set-background (get-panel-background))
      ;; ...and the font.
      (send (send this get-dc) set-font font))))